/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8272;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.AccessDenied;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.launcher.LaunchContext;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class BoxInfo {
    private static ResourceBundle myBundle;
    private static String bundleName;
    private String NavDestination = new String("ibm.nways.jdm8272.eui.PortPanelPanel");
    private static final int RASID = 19;
    private static final int RASSUB = 22;
    public static final String PROPNAME = "BoxInfo.jdm8272.nways.ibm";
    public static final String serPath = "ibm.nways.jdm8272.WCDefault";
    private static final int MAX_NUM_OF_MOD_PORTS = 32;
    private static final int SUCCESSFUL = 0;
    private static final int FAILED = 1;
    public static final int NoStatus = 0;
    public static final int AllisWell = 1;
    public static final int NotResponding = 2;
    public static final int WrongBox = 3;
    public static final int ServerProblems = 4;
    OIDInfo oidInfo = new OIDInfo();
    UFCInfo ufcInfo = new UFCInfo();
    private GenModel deviceModel;
    private GenModel portModel;
    private GenModel systemModel;
    private GenModel UFCModel;
    private GenModel interfaceModel;
    private GenModel snmpModel;
    private GenModel portStatusModel;
    private Vector ufcInfoVector;
    private Vector snmpInfoVector;
    private JdmBrowser deviceBrowser;
    private int deviceStatus;
    private int retrievalStatus;
    private GraphicPanel deviceGraphic;
    private OID deviceSysOID;
    private Vector ufcVector;
    private int NumOfUFCs;
    private int agentVersion;
    GraphicPanel graphicPanel;
    GraphicContainer grContainer;

    public BoxInfo(GenModel genModel, JdmBrowser jdmBrowser) {
        ModelInfo modelInfo = null;
        Serializable serializable = null;
        if (RAS.isEnabled(19, 22)) {
            RAS.trace(19, 22, this, "BoxInfo", "constructor entering");
        }
        this.deviceBrowser = jdmBrowser;
        this.deviceModel = genModel;
        myBundle = ResourceBundle.getBundle(bundleName);
        try {
            modelInfo = this.deviceModel.getInfo("InitialConfig");
            serializable = modelInfo.get("InitialConfig.SysObjectID");
            if (serializable instanceof Timeout || serializable instanceof NotSupported || serializable instanceof AccessDenied) {
                this.deviceStatus = 2;
                if (RAS.isEnabled(19, 22)) {
                    RAS.trace(19, 22, this, "BoxInfo", "Device not responding " + serializable.toString());
                }
                new BoxDownMsg(jdmBrowser.getFrame(), myBundle.getString("deviceName"));
                return;
            }
            this.deviceSysOID = new OID(serializable.toString());
            if (this.oidInfo.containsKey(this.deviceSysOID)) {
                this.deviceStatus = 1;
                this.retrievalStatus = this.getNecessaryModels();
                return;
            }
            this.deviceStatus = 3;
            if (RAS.isEnabled(19, 22)) {
                RAS.trace(19, 22, this, "BoxInfo", "Wrong device. SysOID = " + this.deviceSysOID);
            }
            new WrongSysOidMsg(this.deviceBrowser.getFrame(), myBundle.getString("deviceName"));
            return;
        }
        catch (Exception exception) {
            this.deviceStatus = 4;
            RAS.logError(19, 22, this, "BoxInfo", "EXCEPTION_GETTING_MODELINFO", (Object)"InitialConfig", (Object)"Jdm8272Model");
            RAS.logException(19, 22, this, "BoxInfo", exception);
            return;
        }
    }

    public static void setInNavContext(NavigationContext navigationContext, BoxInfo boxInfo) {
        navigationContext.put((Object)PROPNAME, (Object)boxInfo);
    }

    public static BoxInfo getFromNavContext(NavigationContext navigationContext, boolean bl) {
        return (BoxInfo)navigationContext.get((Object)PROPNAME, bl);
    }

    public JdmBrowser getDeviceBrowser() {
        return this.deviceBrowser;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public GenModel getDeviceModel() {
        return this.deviceModel;
    }

    public GraphicPanel getDeviceGraphic() {
        if (this.deviceStatus == 1 && this.retrievalStatus == 0) {
            if (this.deviceGraphic != null) {
                return this.deviceGraphic;
            }
            JdmLayout jdmLayout = (JdmLayout)this.deviceBrowser.getLayout();
            jdmLayout.setScheme(this.oidInfo.getScheme(this.deviceSysOID));
            this.grContainer = new GraphicContainer();
            GraphicHelp graphicHelp = new GraphicHelp((BrowserApplet)this.deviceBrowser, new Point(0, 0), new HelpRef((Object)this));
            this.grContainer.add((GraphicComponent)graphicHelp);
            this.ufcVector = this.getTokenRingUFCInfo();
            this.NumOfUFCs = this.ufcVector.size();
            this.grContainer.add((GraphicContainer)this.createModel(this.deviceSysOID, this.ufcVector));
            this.graphicPanel = new GraphicPanel((GraphicHandler)this.deviceBrowser, (Component)this.grContainer);
        }
        return this.graphicPanel;
    }

    private int getNecessaryModels() {
        int n = 0;
        int n2 = 1;
        if (RAS.isEnabled(19, 22)) {
            RAS.trace(19, 22, this, "getNecessaryModels", "Attempting to retrieve the following components:");
        }
        if (RAS.isEnabled(19, 22)) {
            RAS.trace(19, 22, this, "getNecessaryModels", "Ibm8272TsPort, System, Ibm8272TsUFC, Interface, Ibm8272TsSnmpInfo, PortStatus");
        }
        try {
            this.portModel = (GenModel)this.deviceModel.getComponent("Ibm8272TsPort");
            n2 = 2;
            this.systemModel = (GenModel)this.deviceModel.getComponent("System");
            n2 = 3;
            this.UFCModel = (GenModel)this.deviceModel.getComponent("Ibm8272TsUFC");
            n2 = 4;
            this.interfaceModel = (GenModel)this.deviceModel.getComponent("Interface");
            n2 = 5;
            this.snmpModel = (GenModel)this.deviceModel.getComponent("Ibm8272TsSnmpInfo");
            n2 = 6;
            this.portStatusModel = (GenModel)this.deviceModel.getComponent("PortStatus");
            n = this.getNecessaryVectors();
        }
        catch (Exception exception) {
            n = 1;
            if (n2 == 6) {
                RAS.logError(19, 22, this, "getNecessaryModels", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"PortStatus", (Object)"Jdm8272Model");
            } else if (n2 == 5) {
                RAS.logError(19, 22, this, "getNecessaryModels", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Ibm8272TsSnmpInfo", (Object)"Jdm8272Model");
            } else if (n2 == 4) {
                RAS.logError(19, 22, this, "getNecessaryModels", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Interface", (Object)"Jdm8272Model");
            } else if (n2 == 3) {
                RAS.logError(19, 22, this, "getNecessaryModels", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Ibm8272TsUFC", (Object)"Jdm8272Model");
            } else if (n2 == 2) {
                RAS.logError(19, 22, this, "getNecessaryModels", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"System", (Object)"Jdm8272Model");
            } else {
                RAS.logError(19, 22, this, "getNecessaryModels", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Ibm8272TsPort", (Object)"Jdm8272Model");
            }
            RAS.logException(19, 22, this, "getNecessaryModels", exception);
        }
        return n;
    }

    private int getNecessaryVectors() {
        this.ufcInfoVector = new Vector();
        this.snmpInfoVector = new Vector();
        int n = 0;
        try {
            this.ufcInfoVector = this.UFCModel.getRestOfInfo("Panel", "default", null, null);
            this.snmpInfoVector = this.snmpModel.getRestOfInfo("Panel", "default", null, null);
        }
        catch (Exception exception) {
            n = 1;
            RAS.logException(19, 22, this, "getNcessaryVectors", exception);
        }
        return n;
    }

    public void setLaunchData(NavigationContext navigationContext) {
        Vector<Properties> vector = new Vector<Properties>();
        if (this.deviceStatus == 1 && this.retrievalStatus == 0) {
            if (RAS.isEnabled(19, 22)) {
                RAS.trace(19, 22, this, "setLaunchData", "Building the Launch Data");
            }
            LaunchContext launchContext = new LaunchContext();
            int n = 0;
            while (n < this.ufcInfoVector.size()) {
                ModelInfo modelInfo = (ModelInfo)this.ufcInfoVector.elementAt(n);
                Serializable serializable = modelInfo.get("Panel.Ibm8272TsUFCSlotNum");
                if (serializable instanceof Integer) {
                    int n2 = (Integer)serializable;
                    serializable = modelInfo.get("Panel.Ibm8272TsUFCTypeDesc");
                    String string = serializable instanceof String ? (String)((Object)serializable) : new String("bad");
                    serializable = modelInfo.get("Panel.Ibm8272TsUFCType");
                    if (serializable instanceof OctetString) {
                        String string2 = serializable.toString();
                        if (string2.startsWith("cf") && string.startsWith("MSS D")) {
                            string2 = new String("c2");
                        }
                        if (launchContext.containsKey(string2)) {
                            String string3 = launchContext.getName(string2);
                            int n3 = 0;
                            while (n3 < this.snmpInfoVector.size()) {
                                int n4;
                                ModelInfo modelInfo2 = (ModelInfo)this.snmpInfoVector.elementAt(n3);
                                serializable = modelInfo2.get("Panel.Ibm8272TsSnmpInfoSlotNum");
                                if (serializable instanceof Integer && (n4 = ((Integer)serializable).intValue()) == n2 && (serializable = modelInfo2.get("Panel.Ibm8272TsSnmpInfoEntryNum")) instanceof Integer && (Integer)serializable == 1 && (serializable = modelInfo2.get("Panel.Ibm8272TsSnmpInfoIpAddress")) instanceof IPAddress) {
                                    String string4 = ((IPAddress)serializable).toString();
                                    String string5 = "Slot " + n2 + " " + string3 + " [" + string4 + "] ";
                                    launchContext.setNavTitle(string2, string5);
                                    launchContext.setSlotNumber(string2, new Integer(n2).toString());
                                    launchContext.setIpAddress(string2, string4);
                                    Properties properties = launchContext.getProp(string2);
                                    vector.addElement(properties);
                                }
                                ++n3;
                            }
                        }
                    }
                }
                ++n;
            }
            navigationContext.put((Object)"launcherFolderContext", vector);
        }
    }

    public void dispose() {
        if (this.deviceGraphic != null) {
            this.deviceGraphic.dispose();
            this.deviceGraphic = null;
        }
    }

    private CookieTray createModel(OID oID, Vector vector) {
        Vector vector2;
        Vector vector3;
        Vector vector4;
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Serializable serializable2;
        Object object4;
        WidgetCookie widgetCookie;
        String string;
        String string2;
        String string3;
        String string4;
        String[] stringArray;
        int[] nArray;
        Vector<CookieTray> vector5;
        Point point;
        String string5;
        int n;
        block47: {
            n = 0;
            this.oidInfo.getNumPorts(oID);
            int n2 = this.oidInfo.getNumSlots(oID);
            string5 = this.oidInfo.getModel(oID);
            point = new Point(-1, -1);
            vector5 = new Vector<CookieTray>();
            nArray = new int[n2 + 5];
            stringArray = new String[n2 + 5];
            string4 = new String();
            string3 = new String("/ibm/nways/jdm8272/" + this.oidInfo.getImage(oID));
            string2 = this.oidInfo.getOrientation(oID);
            try {
                string4 = new String(string5.substring(5));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                ++n;
                if (!RAS.isEnabled(19, 22)) break block47;
                RAS.trace(19, 22, this, "createModel", "An exception ocurred while attempting to retrieve model name info");
            }
        }
        if (RAS.isEnabled(19, 22)) {
            RAS.trace(19, 22, this, "createModel", "Attempting to display " + string5);
        }
        CookieTray cookieTray = new CookieTray(bundleName, this.oidInfo.getPosition(oID), string3, string5, this.deviceBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel");
        int n3 = 0;
        while (n3 < this.oidInfo.getNumOfExtras(oID)) {
            string = new String("r" + string4 + this.oidInfo.getExtras(oID, n3));
            if (RAS.isEnabled(19, 22)) {
                RAS.trace(19, 22, this, "createModel", "Extra port id =" + string);
            }
            try {
                widgetCookie = new WidgetCookie(string, bundleName, null, serPath, null, this.deviceBrowser, 22);
                cookieTray.AddWidget(widgetCookie);
            }
            catch (NullPointerException nullPointerException) {
                ++n;
                if (RAS.isEnabled(19, 22)) {
                    RAS.trace(19, 22, this, "createModel", "Error:  Null pointer exception while creating WidgetCookie for port = " + string);
                }
                RAS.logException(19, 22, this, "createModel", (Exception)nullPointerException);
            }
            ++n3;
        }
        if (n > 0) {
            return cookieTray;
        }
        int n4 = 0;
        while (n4 < this.NumOfUFCs) {
            int n5 = (Integer)((Hashtable)vector.elementAt(n4)).get("SlotNumber");
            if (n5 <= this.oidInfo.getNumSlots(oID)) {
                String cfr_ignored_0 = (String)((Hashtable)vector.elementAt(n4)).get("UFCDescr");
                object4 = ((Hashtable)vector.elementAt(n4)).get("UFCType");
                serializable2 = (OctetString)object4;
                serializable = new Point(this.oidInfo.getSlotCoords(oID, n5));
                if (((OctetString)serializable2).equals(new OctetString("cf"))) {
                    if (RAS.isEnabled(19, 22)) {
                        RAS.trace(19, 22, this, "createModel", "Resolving coordinates for MSS Client");
                    }
                    if (string2.equals("HORIZONTAL")) {
                        ((Point)serializable).translate(0, -36);
                    } else if (string2.equals("LEFT")) {
                        ((Point)serializable).translate(0, 0);
                    } else if (string2.equals("RIGHT")) {
                        ((Point)serializable).translate(-36, 0);
                    }
                }
                object3 = new String("/ibm/nways/gifs/24_scale/" + this.ufcInfo.getImage((OctetString)serializable2, this.oidInfo.getOrientation(oID)));
                object2 = this.ufcInfo.getName((OctetString)serializable2);
                object = this.ufcInfo.getPortsType((OctetString)serializable2);
                int n6 = this.ufcInfo.getNumPorts((OctetString)serializable2);
                if (!((Point)serializable).equals(point)) {
                    try {
                        CookieTray cookieTray2 = new CookieTray(bundleName, (Point)serializable, (String)object3, (String)object2, this.deviceBrowser, this.UFCModel, "ibm.nways.jdm8272.eui.UFCPanel");
                        while (n5 > vector5.size()) {
                            vector5.addElement(null);
                        }
                        vector5.addElement(cookieTray2);
                        stringArray[n5] = new String((String)object);
                        nArray[n5] = n6;
                    }
                    catch (Exception exception) {
                        ++n;
                        if (RAS.isEnabled(19, 22)) {
                            RAS.trace(19, 22, this, "createModel", "Error:  Null pointer exception while creating CookieTray for '" + (String)object2 + "'");
                        }
                        RAS.logException(19, 22, this, "createModel", exception);
                    }
                } else {
                    if (RAS.isEnabled(19, 22)) {
                        RAS.trace(19, 22, this, "createModel", "Error , there is no slot number " + n5 + " in this box");
                    }
                    ++n;
                    break;
                }
            }
            ++n4;
        }
        if (n > 0) {
            return cookieTray;
        }
        try {
            vector4 = this.portModel.getRestOfInfo("GrInfo", "default", null, null);
        }
        catch (Exception exception) {
            ++n;
            vector4 = new Vector();
            RAS.logError(19, 22, this, "createModel", "EXCEPTION_GETTING_MODELINFO", (Object)"GrInfo", (Object)"Ibm8272TsPort");
            RAS.logException(19, 22, this, "createModel", exception);
        }
        try {
            vector3 = this.interfaceModel.getRestOfInfo("Panel", "default", null, null);
        }
        catch (Exception exception) {
            ++n;
            vector3 = new Vector();
            RAS.logError(19, 22, this, "createModel", "EXCEPTION_GETTING_MODELINFO", (Object)"Panel", (Object)"Interface");
            RAS.logException(19, 22, this, "createModel", exception);
        }
        try {
            vector2 = this.portStatusModel.getRestOfInfo("Panel", "default", null, null);
        }
        catch (Exception exception) {
            ++n;
            vector2 = new Vector();
            RAS.logError(19, 22, this, "createModel", "EXCEPTION_GETTING_MODELINFO", (Object)"Panel", (Object)"PortStatus");
            RAS.logException(19, 22, this, "createModel", exception);
        }
        if (n > 0) {
            return cookieTray;
        }
        int n7 = 1;
        while (n7 <= vector2.size()) {
            object4 = new ModelInfo();
            serializable2 = new ModelInfo();
            serializable = (ModelInfo)vector2.elementAt(n7 - 1);
            object3 = (Integer)((ModelInfo)serializable).get("Index.Ibm8272TsPortIndex");
            object2 = (Integer)((ModelInfo)serializable).get("Panel.Ibm8272TsPortIfIndex");
            ((ModelInfo)serializable2).add("Index.Ibm8272TsPortIndex", (Serializable)object3);
            if (RAS.isEnabled(19, 22)) {
                RAS.trace(19, 22, this, "createModel", "Port index =" + n7 + " interface index = " + object2);
            }
            if ((Integer)object2 < 32) {
                object = (ModelInfo)vector4.elementAt(n7 - 1);
                Integer n8 = (Integer)((ModelInfo)object).get("Index.Ibm8272TsPortIndex");
                ((ModelInfo)object4).add("Index.Ibm8272TsPortIndex", n8);
                string = new String("r" + string4 + "Port" + n7);
                if (RAS.isEnabled(19, 22)) {
                    RAS.trace(19, 22, this, "createModel", "Regular Port id = " + string);
                }
                try {
                    widgetCookie = new WidgetCookie(string, bundleName, (ModelInfo)serializable2, serPath, this.portStatusModel, this.deviceBrowser, 18);
                    cookieTray.AddWidget(widgetCookie);
                    widgetCookie.SetAction(this.portModel, (ModelInfo)object4, this.NavDestination);
                }
                catch (NullPointerException nullPointerException) {
                    ++n;
                    if (RAS.isEnabled(19, 22)) {
                        RAS.trace(19, 22, this, "createModel", "Error:  Null pointer exception while creating CookieWidget");
                    }
                    RAS.logException(19, 22, this, "createModel", (Exception)nullPointerException);
                }
            } else if ((Integer)object2 > 100) {
                n = this.createModularPorts(stringArray, (Integer)object2, nArray, oID, (ModelInfo)serializable2, vector4, n, vector5, false);
            }
            ++n7;
        }
        int n9 = 1;
        while (n9 <= vector3.size()) {
            serializable2 = new ModelInfo();
            serializable = (ModelInfo)vector3.elementAt(n9 - 1);
            object3 = (Integer)((ModelInfo)serializable).get("Index.IfIndex");
            if ((Integer)object3 % 100 == 33) {
                ((ModelInfo)serializable2).add("Index.IfIndex", (Serializable)object3);
                n = this.createModularPorts(stringArray, (Integer)object3, nArray, oID, (ModelInfo)serializable2, vector4, n, vector5, true);
            }
            ++n9;
        }
        int n10 = 0;
        while (n10 < vector5.size()) {
            if (vector5.elementAt(n10) != null) {
                cookieTray.add((GraphicContainer)((CookieTray)vector5.elementAt(n10)));
            }
            ++n10;
        }
        if (n > 0 && RAS.isEnabled(19, 22)) {
            RAS.trace(19, 22, this, "createModel", "Warning, there were " + n + " minor errors in creating the device graphic");
        }
        return cookieTray;
    }

    public int createModularPorts(String[] stringArray, Integer n, int[] nArray, OID oID, ModelInfo modelInfo, Vector vector, int n2, Vector vector2, boolean bl) {
        block14: {
            boolean bl2 = false;
            ModelInfo modelInfo2 = new ModelInfo();
            int n3 = n / 100;
            String string = new String("NONE");
            if (stringArray[n3] != null) {
                string = stringArray[n3];
            }
            int n4 = n % 100;
            if (RAS.isEnabled(19, 22)) {
                RAS.trace(19, 22, this, "createModel", "whichPORTonUFC= " + n4);
            }
            if (string.equals("MSSClient")) {
                if (n4 != 33) {
                    return n2;
                }
                n4 = 1;
            }
            if (RAS.isEnabled(19, 22)) {
                RAS.trace(19, 22, this, "createModel", "whichPORTonUFC= " + n4);
            }
            if (nArray[n3] >= n4) {
                bl2 = true;
            }
            if (RAS.isEnabled(19, 22)) {
                RAS.trace(19, 22, this, "createModel", "addModPort = " + bl2);
            }
            if (!bl2) break block14;
            String string2 = new String(String.valueOf(string) + "Port" + n4);
            if (RAS.isEnabled(19, 22)) {
                RAS.trace(19, 22, this, "createModel", "Modular Port id = " + string2);
            }
            string2 = this.oidInfo.getOrientation(oID).equals("HORIZONTAL") ? new String("h" + string2) : (this.oidInfo.getOrientation(oID).equals("RIGHT") ? new String("v" + string2) : new String("n" + string2));
            try {
                WidgetCookie widgetCookie = bl ? new WidgetCookie(string2, bundleName, modelInfo, serPath, this.interfaceModel, this.deviceBrowser, 18) : new WidgetCookie(string2, bundleName, modelInfo, serPath, this.portStatusModel, this.deviceBrowser, 18);
                if (string.equals("MSSClient")) {
                    widgetCookie.SetFlyover("MSS Port", n4);
                } else {
                    Integer n5;
                    ModelInfo modelInfo3;
                    int n6 = 0;
                    while (n6 < vector.size() - 1) {
                        modelInfo3 = (ModelInfo)vector.elementAt(n6);
                        n5 = (Integer)modelInfo3.get("GrInfo.Ibm8272TsPortIfIndex");
                        if (n5.intValue() == n.intValue()) break;
                        ++n6;
                    }
                    modelInfo3 = (ModelInfo)vector.elementAt(n6);
                    n5 = (Integer)modelInfo3.get("GrInfo.Ibm8272TsPortIndex");
                    Integer n7 = (Integer)modelInfo3.get("Index.Ibm8272TsPortIndex");
                    modelInfo2.add("Index.Ibm8272TsPortIndex", n7);
                    widgetCookie.SetAction(this.portModel, modelInfo2, this.NavDestination);
                    widgetCookie.SetFlyover("Port", n5.intValue());
                }
                ((CookieTray)vector2.elementAt(n3)).AddWidget(widgetCookie);
            }
            catch (Exception exception) {
                ++n2;
                if (RAS.isEnabled(19, 22)) {
                    RAS.trace(19, 22, this, "createModel", "Error: when creating WidgetCookie " + string2);
                }
                RAS.logException(19, 22, this, "createModel", exception);
            }
        }
        return n2;
    }

    public Vector getTokenRingUFCInfo() {
        Vector vector = new Vector();
        Hashtable<String, Object> hashtable = null;
        if (RAS.isEnabled(19, 22)) {
            RAS.trace(19, 22, this, "getTokenRingUFCInfo", "Getting the UFC information");
        }
        int n = 0;
        while (n < this.ufcInfoVector.size()) {
            ModelInfo modelInfo = (ModelInfo)this.ufcInfoVector.elementAt(n);
            hashtable = new Hashtable<String, Object>();
            Serializable serializable = modelInfo.get("Panel.Ibm8272TsUFCSlotNum");
            if (serializable instanceof Integer) {
                hashtable.put("SlotNumber", (Integer)serializable);
            } else {
                hashtable.put("SlotNumber", new Integer(-1));
            }
            serializable = modelInfo.get("Panel.Ibm8272TsUFCTypeDesc");
            if (serializable instanceof String) {
                hashtable.put("UFCDescr", (String)((Object)serializable));
            } else {
                hashtable.put("UFCDescr", new String("-"));
            }
            serializable = modelInfo.get("Panel.Ibm8272TsUFCType");
            if (serializable instanceof OctetString) {
                if (serializable.toString().equals("cf")) {
                    if (((String)hashtable.get("UFCDescr")).startsWith("MSS D")) {
                        hashtable.put("UFCType", new OctetString("c2"));
                    } else {
                        hashtable.put("UFCType", (OctetString)serializable);
                    }
                } else {
                    hashtable.put("UFCType", (OctetString)serializable);
                }
            } else {
                hashtable.put("UFCType", new OctetString("ff"));
            }
            vector.addElement(hashtable);
            ++n;
        }
        return vector;
    }

    static {
        bundleName = "ibm.nways.jdm8272.GeneralResources";
    }

    private class OIDTable
    extends Hashtable {
        public void create(OID oID) {
            try {
                this.put(oID, new Hashtable());
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        public Hashtable getHash(OID oID) {
            return (Hashtable)this.get(oID);
        }

        OIDTable() {
            BoxInfo.this = BoxInfo.this;
        }
    }

    private class OIDInfo {
        OIDTable oidTable;

        public OIDInfo() {
            BoxInfo.this = BoxInfo.this;
            this.oidTable = new OIDTable();
            OID oID = new OID("1.3.6.1.4.1.2.6.66.1.1.108");
            Integer n = new Integer(1);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8272-108");
            this.oidTable.getHash(oID).put("Image", "8272-108.gif");
            this.oidTable.getHash(oID).put("Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Scheme", new Integer(0));
            this.oidTable.getHash(oID).put("Orientation", "HORIZONTAL");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(312, 5));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(8));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(3));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Power");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Reset");
            oID = new OID("1.3.6.1.4.1.2.6.66.1.1.208");
            n = new Integer(2);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8272-208");
            this.oidTable.getHash(oID).put("Image", "8272-208.gif");
            this.oidTable.getHash(oID).put("Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Scheme", new Integer(1));
            this.oidTable.getHash(oID).put("Orientation", "RIGHT");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(37, 279));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(37, 28));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(8));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(1));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            oID = new OID("1.3.6.1.4.1.2.6.66.1.1.216");
            n = new Integer(2);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8272-216");
            this.oidTable.getHash(oID).put("Image", "8272-216.gif");
            this.oidTable.getHash(oID).put("Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Scheme", new Integer(0));
            this.oidTable.getHash(oID).put("Orientation", "HORIZONTAL");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(57, 5));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(313, 5));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(16));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(3));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Power");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Reset");
            oID = new OID("1.3.6.1.4.1.2.6.66.1.1.408");
            n = new Integer(4);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8272-408");
            this.oidTable.getHash(oID).put("Image", "8272-408.gif");
            this.oidTable.getHash(oID).put("Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Scheme", new Integer(1));
            this.oidTable.getHash(oID).put("Orientation", "RIGHT");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(38, 279));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(38, 28));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(74, 279));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(74, 28));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(8));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(1));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            oID = new OID("1.3.6.1.4.1.2.6.66.1.1.600");
            n = new Integer(6);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8270-600");
            this.oidTable.getHash(oID).put("Image", "8270-600.gif");
            this.oidTable.getHash(oID).put("Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Scheme", new Integer(0));
            this.oidTable.getHash(oID).put("Orientation", "HORIZONTAL");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(120, 66));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(120, 30));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(363, 138));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(363, 102));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(363, 66));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(363, 30));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(0));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(2));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Power");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            oID = new OID("1.3.6.1.4.1.2.6.66.1.1.800");
            n = new Integer(8);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8270-800");
            this.oidTable.getHash(oID).put("Image", "8270-800.gif");
            this.oidTable.getHash(oID).put("Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Scheme", new Integer(0));
            this.oidTable.getHash(oID).put("Orientation", "LEFT");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(310, 43));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(345, 43));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(380, 43));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(415, 43));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(450, 43));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(485, 43));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(520, 43));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(555, 43));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(0));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(3));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Power1");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Power2");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
        }

        public String getModel(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Model");
        }

        public String getImage(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Image");
        }

        public Point getPosition(OID oID) {
            return (Point)this.oidTable.getHash(oID).get("Position");
        }

        public int getScheme(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Scheme");
        }

        public String getOrientation(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Orientation");
        }

        public int getNumSlots(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of Slots");
        }

        public int getNumPorts(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of Ports");
        }

        public Point getSlotCoords(OID oID, int n) {
            if (n - 1 >= ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).size()) {
                return new Point(-1, -1);
            }
            return (Point)((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).elementAt(n - 1);
        }

        public int getNumOfExtras(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of extra stuff");
        }

        public String getExtras(OID oID, int n) {
            if (n >= ((Vector)this.oidTable.getHash(oID).get("Extras")).size()) {
                return new String();
            }
            return (String)((Vector)this.oidTable.getHash(oID).get("Extras")).elementAt(n);
        }

        public boolean containsKey(OID oID) {
            return this.oidTable.containsKey(oID);
        }
    }

    private class UFCTable
    extends Hashtable {
        public void create(String string) {
            try {
                this.put(string, new Hashtable());
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        public Hashtable getProp(String string) {
            if (this.containsKey(string)) {
                return (Hashtable)this.get(string);
            }
            return (Hashtable)this.get("ff");
        }

        UFCTable() {
            BoxInfo.this = BoxInfo.this;
        }
    }

    private class UFCInfo {
        UFCTable ufcTypes;

        public UFCInfo() {
            BoxInfo.this = BoxInfo.this;
            this.ufcTypes = new UFCTable();
            String string = new String("ff");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "UFC Blank Cover");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/hUFCBlankCover.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/vUFCBlankCover.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/nUFCBlankCover.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(2));
            this.ufcTypes.getProp(string).put("Ports Type", "155ATM");
            string = new String("c0");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "1-Port 155 Mbps ATM");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h1Port155MbpsATM.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/v1Port155MbpsATM.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/n1Port155MbpsATM.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(1));
            this.ufcTypes.getProp(string).put("Ports Type", "155ATM");
            string = new String("c1");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "1-Port 155 Mbps ATM");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h1Port155MbpsATM.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/v1Port155MbpsATM.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/n1Port155MbpsATM.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(1));
            string = new String("03");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "1-Port 100BASE-TX");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h1Port100BASETX.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/v1Port100BASETX.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/n1Port100BASETX.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(1));
            this.ufcTypes.getProp(string).put("Ports Type", "100BASETX");
            string = new String("06");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "4-Port 10BASE-T");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h4Port10BASET.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/v4Port10BASET.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/n4Port10BASET.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(4));
            this.ufcTypes.getProp(string).put("Ports Type", "10BASET");
            string = new String("08");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "3-Port 10BASE-FL");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h3Port10BASEFL.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/v3Port10BASEFL.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/n3Port10BASEFL.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(3));
            this.ufcTypes.getProp(string).put("Ports Type", "10BASEFL");
            string = new String("05");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "1-Port 100BASE-FX");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h1Port100BASEFX.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/v1Port100BASEFX.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/n1Port100BASEFX.gif");
            this.ufcTypes.getProp(string).put("Size", new Dimension(243, 36));
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(1));
            this.ufcTypes.getProp(string).put("Ports Type", "100BASEFX");
            string = new String("d7");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "2-Port TR/Enhanced Fiber");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h2PortTREnhancedFiber.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/v2PortTREnhancedFiber.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/n2PortTREnhancedFiber.gif");
            this.ufcTypes.getProp(string).put("Size", new Dimension(243, 36));
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(2));
            this.ufcTypes.getProp(string).put("Ports Type", "EFIBER");
            string = new String("d9");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "4-Port TR/Enhanced UTP/STP");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h4PortTREnhancedUTPSTP.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/v4PortTREnhancedUTPSTP.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/n4PortTREnhancedUTPSTP.gif");
            this.ufcTypes.getProp(string).put("Size", new Dimension(243, 36));
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(4));
            this.ufcTypes.getProp(string).put("Ports Type", "TR_UTPSTP");
            string = new String("c2");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "MSS Domain Client");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/hMSSDomainClient.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/vMSSDomainClient.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/nMSSDomainClient.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(0));
            this.ufcTypes.getProp(string).put("Ports Type", "NONE");
            string = new String("cf");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "MSS Client");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/hMSSClient.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/vMSSClient.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/nMSSClient.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(1));
            this.ufcTypes.getProp(string).put("Ports Type", "MSSClient");
            string = new String("ca");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "2-Port HSTR UTP/STP");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h2PortHSTR_UTPSTP.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/v2PortHSTR_UTPSTP.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/n2PortHSTR_UTPSTP.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(2));
            this.ufcTypes.getProp(string).put("Ports Type", "HSTR_UTPSTP");
            string = new String("cb");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "2-Port HSTR Fiber");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h2PortHSTR_Fiber.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/v2PortHSTR_Fiber.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/n2PortHSTR_Fiber.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(2));
            this.ufcTypes.getProp(string).put("Ports Type", "HSTR_Fiber");
        }

        public String getName(OctetString octetString) {
            return (String)this.ufcTypes.getProp(octetString.toString()).get("Name");
        }

        public String getImage(OctetString octetString, String string) {
            String string2 = new String(String.valueOf(string) + " Image");
            return (String)this.ufcTypes.getProp(octetString.toString()).get(string2);
        }

        public String getPortsType(OctetString octetString) {
            return (String)this.ufcTypes.getProp(octetString.toString()).get("Ports Type");
        }

        public Dimension getSize(OctetString octetString) {
            return (Dimension)this.ufcTypes.getProp(octetString.toString()).get("Size");
        }

        public int getNumPorts(OctetString octetString) {
            return (Integer)this.ufcTypes.getProp(octetString.toString()).get("Number of Ports");
        }
    }
}

